/** @file   carnivorealien.h
 * @brief   Declaration of CarnivoreAlien - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_CARNIVOREALIEN_H
#define H_WWW_CARNIVOREALIEN_H

#include "alien.h"


namespace WeWantWar {

/** @class  CarnivoreAlien
 * @brief   Brown alien that tries to tear player apart.
 * @author    Tomi Lamminsaari
 *
 * This class represents the most popular alien of the game.
 * It is brown alien that tries to attack the player and tear player apart.
 */
class CarnivoreAlien : public Alien
{
public:

  ///
  /// Constructors, destructor
  /// ========================
  
  /** Constructs new CarnivoreAlien.
   */
  CarnivoreAlien();
  
  /** Destructor.
   */
  virtual ~CarnivoreAlien();
  
  
  
  ///
  /// Methods
  /// =======
  
  /** Reimplemented update-method. Moves and controls this alien.
   */
  virtual void update();

  
  /** Kills this object.
   */
  virtual void kill();
  
  /** Makes sound.
   * @param     id                ID of the sound we should make.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** This alien got hit by given bullet. The bullets can go through the
   * Alien if it was shot by another alien.
   * @param     pB                Pointer to bullet that hit us.
   * @return    'true' if this bullet did hit us. 'false' means it went
   *            through.
   */
  virtual bool hitByBullet( Bullet* pB );
  
  
  ///
  /// Getter methods
  /// ==============
  
  /** Returns the type of this object.
   * @return    ObjectID::TYPE_CARNIVOREALIEN
   */
  virtual ObjectID::Type objectType() const;
  
  
  
protected:

  /** Sets the requested animation.
   * @param     aAnimId           ID-code of the animation to set up.
   */
  virtual void setCorrectAnimation( int aAnimId );
  
  /** Attacks the target.
   */
  virtual void attack();
  

  ///
  /// Members
  /// =======
  
  /** The movement vector. */
  eng2d::Vec2D  m_spdVec;
  /** How much damage this alien causes to the player. */
  int     m_damagePoints;

private:
  CarnivoreAlien( const CarnivoreAlien& rO );
  CarnivoreAlien& operator = ( const CarnivoreAlien& rO );
};

};  // end of namespace

#endif // CARNIVOREALIEN_H

/**
 * Version history
 * ===============
 * $Log: carnivorealien.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:51+02  lamminsa
 * Initial revision
 *
 */
